// Transmissionsmessung (Display ist optional)
// Dieser Sketch funktioniert mit einem Display, dem VEMBL UV Sensor, und der UV-LED von Nichia.
// Das Display und der Sensor werden über den SDA Bus angeschlossen.
// Dazu wird SDA und SCL vom Arduino auf ein Steckbrett geleitet, und von dort aus an die Bauteile geleitet.
// Die LED Nichia wird über einen Widerstand 110 Ohm an 5V angeschlossen.
// Die Bibliothek für das Display und für den Sensor müssen im Arduino Programm vorher eingebunden werden.
// Dazu in der Arduino IDE unter Werkzeuge-> Bibliotheken die entsprechenden Bibliotheken suchen

#include <SparkFun_VEML6075_Arduino_Library.h>  // Sensor VEML6075 Bibliothek einbinden
#include <LiquidCrystal_I2C.h>                  // LiquidCrystal_I2C Bibliothek einbinden

VEML6075 uv;                                    // Kreieren eines VEML6075 Objekts.
LiquidCrystal_I2C lcd(0x27, 16, 2);             // Hier wird festgelegt um was für einen Display es sich handelt.
                                                // In diesem Fall eines mit 16 Zeichen in 2 Zeilen und der HEX-Adresse 0x27.
                                                // Für ein vierzeiliges I2C-LCD verwendet man den Code "LiquidCrystal_I2C lcd(0x27, 20, 4)"
double uvaref;                                  // Referenz UVA Variable. Wird in der Funktion "setup" bestimmt, und in "loop" genutzt

void setup() {                      // Diese Funktion wird am Anfang einmal ausgeführt
  Serial.begin(9600);               // Initialisierung der Kommunikation zum Arduino
  uv.begin();                       // Im Setup wird der Sensor gestartet

  lcd.init();                       // Im Setup wird das LCD gestartet
  lcd.backlight();                  // Das Hintergrundlicht des Displays wird angeschaltet
  lcd.print("Initialisieren");      // Das Wort "Initialisieren" wird auf das Display geschrieben

  Serial.println("Initialisieren"); // Das Wort "Initialisieren" wird zusätzlich zum seriellen Monitor geschickt

  // --- Sensor einstellen ---
  uv.setIntegrationTime(VEML6075::IT_800MS);  // Integration time: The VEML6075 features five selectable integration times.
  // This is the amount of time the sensor takes to sample UVA/UVB values,
  // before integrating the readings into averages.
  uv.setHighDynamic(VEML6075::DYNAMIC_HIGH);  // High dynamic: The VEML6075 can either be set to normal dynamic or high dynamic mode.
  // In high dynamic mode, the resolution is increased by about a factor of two.

  // --- Referenzwerte bestimmen ---
  double uvatemp;                             // Temporäre Variable, um den Referenz UVA Wert zu berechnen
  for (int i = 1; i <= 1000; i++) {           // Mittelwert der ersten 1000 UV-Werte ausrechnen
    uvatemp = uvatemp + uv.rawUva();
    Serial.println("Initialisierung, Wert: " + String(uvatemp));
  }
  uvaref = uvatemp / 100000;                  // Referenzwert festsetzen, es muss zusätzlich durch 100 geteilt wird
  // --- Initialisierung des Sensors beendet ---


  // ---Display beschriften ---
  lcd.clear();                    // Die Schrift auf dem LCD "löschen"
  lcd.setCursor(1, 0);            // Cursor in die erste Zeile hinter die zweite Einheit setzen
  lcd.print("Transmission");      // hier "Transmission" schreiben

  lcd.setCursor(1, 1);            // Cursor in die zweite Zeile hinter die zweite Einheit setzen
  lcd.print("UV-A:");             // hier "UVA" schreiben
  lcd.setCursor(12, 1);           // Cursor in die zweite Zeile hinter die zwölfte Einheit setzen
  lcd.print("%");                 // hier ein Prozent-Zeichen setzen
  // ---Display beschriften beendet ---
}


void loop() {                         // diese Funktion in einer Endlosschleife ausgeführt
  double uvawert = uv.rawUva();       // aktuellen UV-Wert vom Sensor auslesen

  // --- Ausgabe der Messwerte am Seriellen Monitor ---
  if (uvawert / uvaref < 100) {
    // Falls er aus irgendeinem Grund größer als 100% sein sollte, wird dennoch 100% angezeigt
    Serial.println("UVA: " + String(uvawert / uvaref) + "%"); // Angabe der Transmittierten UV-Strahlung
    // Serial.println(", wert " + String(uvawert) + ", ref" + String(uvaref) ); // falls Fehler auftreten, hier ein Test
  }
  else {
    Serial.println(String(100) + "%"); // Der Sensor registriert mehr als seinen Referenzwert, also 100% ausgegeben
    // Serial.println(", wert " + String(uvawert) + ", ref" + String(uvaref) ); // falls Fehler auftreten, hier ein Test
  }

  // --- Ausgabe der Messwerte am Display ---
  lcd.setCursor(7, 1);
  if (uvawert / uvaref < 100)
  {
    lcd.print(String(int(uvawert / uvaref)) + "  ");
  }
  else {
    lcd.print(String(100));
  }

  delay(250);                         // kurze Wartezeit.
}
