// Dieser Sketch funktioniert mit dem VEMBL UV Sensor, und der UV-LED von Nichia.
// Der Sensor wird über den SDA Bus angeschlossen (SDA und SCL verkabeln).
// Die LED Nichia wird über einen Widerstand 110 Ohm an 5V angeschlossen.
// Die Bibliothek für den Sensor müssen im Arduino Programm vorher eingebunden werden.
// Dazu in der Arduino IDE unter Werkzeuge-> Bibliotheken die entsprechenden Bibliotheken suchen

#include <SparkFun_VEML6075_Arduino_Library.h>  // Sensor VEML6075 Bibliothek einbinden


VEML6075 uv;                                    // Kreieren eines VEML6075 Objekts.
double uvaref;                                  // Referenz UVA Variable. Wird in der Funktion "setup" bestimmt, und in "loop" genutzt

void setup() {                      // Diese Funktion wird am Anfang einmal ausgeführt
  Serial.begin(9600);               // Initialisierung der Kommunikation zum Arduino
  uv.begin();                       // Im Setup wird der Sensor gestartet
  Serial.println("Initialisieren"); // Das Wort "Initialisieren" wird ausgegeben


  // --- Referenzwerte bestimmen ---
  double uvatemp;                             // Temporäre Variable, um den Referenz UVA Wert zu berechnen
  for (int i = 1; i <= 1000; i++) {           // Mittelwert der ersten 1000 UV-Werte ausrechnen
    uvatemp = uvatemp + uv.rawUva();
  }
  uvaref = uvatemp / 100000;                  // Referenzwert festsetzen, es muss zusätzlich durch 100 geteilt wird

}


void loop() {                         // diese Funktion in einer Endlosschleife ausgeführt
  double uvawert = uv.rawUva();       // aktuellen UV-Wert vom Sensor auslesen

  // --- Ausgabe der Messwerte ---
  if (uvawert / uvaref < 100) {
    // Falls er aus irgendeinem Grund größer als 100% sein sollte, wird dennoch 100% ausgegeben
    Serial.println("UVA: " + String(uvawert / uvaref) + "%"); // Angabe der Transmittierten UV-Strahlung
  }
  else {
    Serial.println(String(100) + "%"); // Der Sensor registriert mehr als seinen Referenzwert, also 100% ausgegeben
  }

  delay(250);                         // kurze Wartezeit.
}
