#include <Arduino.h>

double uvatemp; // Temporärer Variable, um den Referenz UVA Wert zu berechnen
double uvaref;  // Referenz UVA Variable. Wird in der Funktion "setup" bestimmt, und in "loop" genutzt
double wert;

void initialise() {

  // --- Sensor einstellen ---

  uv.setIntegrationTime(VEML6075::IT_800MS);  // Integration time: The VEML6075 features five selectable integration times. This is the amount of
  // time the sensor takes to sample UVA/UVB values, before integrating the readings into averages.
  uv.setHighDynamic(VEML6075::DYNAMIC_HIGH);  // High dynamic: The VEML6075 can either be set to normal dynamic or high dynamic mode.
  // In high dynamic mode, the resolution is increased by about a factor of two.

  // --- Referenzwerte bestimmen ---
  for (int i = 1; i <= 1000; i++) {
    uvatemp = uvatemp + uv.rawUva();
    Serial.println("Initialisieren; Summe = " + String(uvatemp));
  }
  uvaref = uvatemp / 100000;            // Referenzwert festsetzen, es muss zusätzlich durch 100 geteilt werden weil Sensor

  // --- Initialisierung des Sensors beendet ---


  // ---Display beschriften ---
  lcd.clear();          // Die Schrift auf dem LCD "löschen"
  lcd.setCursor(1, 0);  // Cursor in die erste Zeile hinter die zweite Einheit setzen
  lcd.print("Transmission"); // hier "Transmission" schreiben

  lcd.setCursor(1, 1);  // Cursor in die zweite Zeile hinter die zweite Einheit setzen
  lcd.print("UV-A:");   // hier "UVA" schreiben
  lcd.setCursor(12, 1); // Cursor in die zweite Zeile hinter die zwölfte Einheit setzen
  lcd.print("%");       // hier ein Prozent-Zeichen setzen


}


void printme(double wert) {

  // --- Ausgabe der Messwerte ---
  if (wert / uvaref < 100) {
    //Falls er aus irgendeinem Grund größer als 100% sein sollte, wird dennoch 100% angezeigt
    Serial.println("UVA: " + String(wert / uvaref) + "%"); // Angabe der Transmittierten UV-Strahlung
    // Serial.println(", wert " + String(wert) + ", ref" + String(uvaref) ); // falls Fehler auftreten, hier ein Test
  }
  else {
    Serial.println(String(100) + "%"); // Der Sensor registriert mehr als seinen Referenzwert, also 100% ausgegeben
    // Serial.println(", wert " + String(wert) + ", ref" + String(uvaref) ); // falls Fehler auftreten, hier ein Test
  }

  // --- Ausgabe am Display ---
  lcd.setCursor(7, 1);
  if (wert / uvaref < 100)
  {
    lcd.print(String(int(wert / uvaref)) + "  ");
  }
  else {
    lcd.print(String(100));
  }

}
