// Dieser Sketch funktioniert mit einem Display, dem VEMBL UV Sensor, und der UV-LED von Nichia.
// Speziell ist hier dei Hilfsdatei funktion.h, die im selben Ordner wie dieses Dokument liegen muss.
// Das Display und der Sensor werden über den SDA Bus angeschlossen.
// Dazu wird SDA und SCL vom Arduino auf ein Steckbrett geleitet, und von dort aus an die Bauteile geleitet.
// Die LED Nichia wird über einen Widerstand 110 Ohm an 5V angeschlossen.
// Die Bibliothek für das Display und für den Sensor müssen im Arduino Programm vorher eingebunden werden.
// Dazu in der Arduino IDE unter Werkzeuge-> Bibliotheken die entsprechenden Bibliotheken suchen.

#include <SparkFun_VEML6075_Arduino_Library.h>      // Sensor VEML6075 Bibliothek einbinden
#include <LiquidCrystal_I2C.h>                      // LiquidCrystal_I2C Bibliothek einbinden

VEML6075 uv;                        // Kreieren eines VEML6075 Objekts.
LiquidCrystal_I2C lcd(0x27, 16, 2); // Hier wird festgelegt um was für einen Display es sich handelt.
                                    // In diesem Fall eines mit 16 Zeichen in 2 Zeilen und der HEX-Adresse 0x27.
                                    // Für ein vierzeiliges I2C-LCD verwendet man den Code "LiquidCrystal_I2C lcd(0x27, 20, 4)"

#include "funktion.h"               // Hier wird die Hilfsdatei eingebunden, in der die hier gebrauchten Funktionen liegen.

void setup() {                      // Diese Funktion wird am Anfang einmal ausgeführt
  Serial.begin(9600);               // Initialisierung der Kommunikation zum Arduino
  uv.begin();                       // Im Setup wird der Sensor gestartet

  lcd.init();                       // Im Setup wird das LCD gestartet
  lcd.backlight();                  // Das Hintergrundlicht des Displays wird angeschaltet
  lcd.print("Initialisieren");      // Das Wort "Initialisieren" wird auf das Display geschrieben
  Serial.println("Initialisieren"); // Das Wort "Initialisieren" wird zusätzlich zum seriellen Monitor geschickt
  initialise();                     // Aufruf der Funktion Initialisierung
}

void loop() {                        // Diese Funktion in einer Endlosschleife ausgeführt
  double uvawert = uv.rawUva();      // Wert vom Sensor auslesen
  printme(uvawert);                  // Aufruf der Funktion printme; Sie macht die Ausgabe der Werte im Seriellen Monitor und auf dem Display
  delay(250);                        // kurze Wartezeit.
}
