// Reflexions- und Streuungsmessungen (Display ist optional)
// Dises Programm funktioniert mit einem Display mit I2C Anschluss, und dem Veml6075 Sensor, der ebenfalls über I2C gesteuert wird.
// Die Clock (SCL) und die Datenleitung (SDA) vom Arduino wird auf ein Steckboard geleitet.
// Die SDA und SCL Anschlüsse von Display und Sensor werden in das Steckboard gesteckt.
// Die LED wird ebenfalls an 5V angeschlossen, und mit einem Widerstand 110 Ohm mit Ground verbunden.
// Die Bibliothek für das Display und für den Sensor müssen im Arduino Programm vorher eingebunden werden.
// Dazu in der Arduino IDE unter Werkzeuge-> Bibliotheken die entsprechenden Bibliotheken suchen


#include <SparkFun_VEML6075_Arduino_Library.h>
#include <LiquidCrystal_I2C.h>      // Vorher hinzugefügte LiquidCrystal_I2C Bibliothek einbinden


VEML6075 uv; // Create a VEML6075 object
LiquidCrystal_I2C lcd(0x27, 16, 2); // Hier wird festgelegt um was für einen Display es sich handelt.
// In diesem Fall eines mit 16 Zeichen in 2 Zeilen und der HEX-Adresse 0x27.
// Für ein vierzeiliges I2C-LCD verwendet man den Code "LiquidCrystal_I2C lcd(0x27, 20, 4)"


double uvatemp;                // Variablen definieren
double uvbtemp;
double uvaref;
double uvbref;

char showTrans[6];


void setup() {

  Serial.begin(9600);
  uv.begin();                   // Im Setup wird der Sensor gestartet
  lcd.init();                   // Im Setup wird das LCD gestartet
  lcd.backlight();              // Das Hintergrundlicht des Displays wird angeschaltet
  lcd.print("Initialisieren");  // Das Wort "Initialisieren" wird auf das Display geschrieben
  delay(5000);                  // Kurz warten
  lcd.clear();                  // Die Schrift auf dem LCD "löschen"

  // Sensor einstellen
  uv.setIntegrationTime(VEML6075::IT_800MS);  // Integration time: The VEML6075 features five selectable integration times. This is the amount of
  // time the sensor takes to sample UVA/UVB values, before integrating the readings into averages.
  uv.setHighDynamic(VEML6075::DYNAMIC_HIGH);  // High dynamnic: The VEML6075 can either be set to normal dynamic or high dynamic mode.
  // In high dynamic mode, the resolution is increased by about a factor of two.


  // Referenzwerte bestimmen
  for (int i = 1; i <= 1000; i++) { // Mittelwert der ersten 1000 UV-Werte ausrechnen
    uvatemp = uvatemp + uv.rawUva();
    uvbtemp = uvbtemp + uv.rawUvb();
  }

  uvaref = uvatemp / 1000;          // Referenzwert UVA festsetzen
  uvbref = uvbtemp / 1000;          // Referenzwert UVB festsetzen

  //Initialisierung beendet


  //Display beschriften
  lcd.setCursor(2, 0);              // Cursor in die erste Zeile hinter die dritte Einheit setzen
  lcd.print("Reflexion");           // hier "Reflexion" schreiben

  lcd.setCursor(2, 1);              // Cursor in die zweite Zeile hinter die dritte Einheit setzen
  lcd.print("UV-A");                // hier "UVA" schreiben



}


void loop() {
  // --- Abrufen des Messwertes ---
  double uvawert = uv.rawUva();

  // --- Ausgabe der Messwerte im seriellen Monitor ---
  if (uvawert > uvaref)                                   // Falls ein Wert größer als der Untergrund gemessen wird
  {
    Serial.println("UVA: " + String(uvawert - uvaref) );  // Hier wird der Untergrundwert vom gemessenen Wert abgezogen
  }
  else {
    Serial.println(String(0) + ", " + String(0));
  }

  // --- Ausgabe der Messwerte auf dem Display ---
  lcd.setCursor(7, 1);                                    // Cursor in die zweite Zeile hinter die achte Einheit setzen
  if (uvawert > uvaref)
  {
    lcd.print(String(uvawert - uvaref));                  // Ausgerechneten Wert anzeigen
  }
  else {
    lcd.print(String(0.0));
  }



  delay(2500);                                            // Kurze Wartezeit
}
